/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.codecs;

import com.agricraft.agricraft.common.util.Platform;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5699;

public record AgriSeed(class_5699.class_7476 item, boolean overridePlanting, class_2487 nbt, double grassDropChance, double seedDropChance, double seedDropBonus) {
    public static final Codec<AgriSeed> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_39274.fieldOf("item").forGetter(seed -> seed.item), (App)Codec.BOOL.fieldOf("override_planting").forGetter(seed -> seed.overridePlanting), (App)class_2487.field_25128.optionalFieldOf("nbt").forGetter(seed -> seed.nbt.method_33133() ? Optional.empty() : Optional.of(seed.nbt)), (App)Codec.DOUBLE.fieldOf("grass_drop_chance").forGetter(plant -> plant.grassDropChance), (App)Codec.DOUBLE.fieldOf("seed_drop_bonus").forGetter(plant -> plant.seedDropBonus), (App)Codec.DOUBLE.fieldOf("seed_drop_chance").forGetter(plant -> plant.seedDropChance)).apply((Applicative)instance, AgriSeed::new));

    public AgriSeed(class_5699.class_7476 item, boolean overridePlanting, Optional<class_2487> nbt, double grassDropChance, double seedDropChance, double seedDropBonus) {
        this(item, overridePlanting, nbt.orElse(new class_2487()), grassDropChance, seedDropChance, seedDropBonus);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isVariant(class_1799 itemStack) {
        List<class_1792> items = Platform.get().getItemsFromLocation(this.item());
        if (items.contains(itemStack.method_7909())) {
            if (this.nbt.method_33133()) {
                return true;
            }
            class_2487 tag = itemStack.method_7948();
            for (String key : this.nbt.method_10541()) {
                if (tag.method_10545(key) && tag.method_10580(key).equals(this.nbt.method_10580(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static class Builder {
        class_5699.class_7476 item;
        boolean overridePlanting = true;
        class_2487 nbt = new class_2487();
        double grassDropChance = 0.0;
        double seedDropChance = 1.0;
        double seedDropBonus = 0.0;

        public AgriSeed build() {
            return new AgriSeed(this.item, this.overridePlanting, this.nbt, this.grassDropChance, this.seedDropChance, this.seedDropBonus);
        }

        public Builder item(String location) {
            this.item = new class_5699.class_7476(new class_2960(location), false);
            return this;
        }

        public Builder item(String namespace, String path) {
            this.item = new class_5699.class_7476(new class_2960(namespace, path), false);
            return this;
        }

        public Builder tag(String location) {
            this.item = new class_5699.class_7476(new class_2960(location), true);
            return this;
        }

        public Builder tag(String namespace, String path) {
            this.item = new class_5699.class_7476(new class_2960(namespace, path), true);
            return this;
        }

        public Builder nbt(class_2487 nbt) {
            this.nbt = nbt;
            return this;
        }

        public Builder chances(double grass, double seed, double seedBonus) {
            this.grassDropChance = grass;
            this.seedDropChance = seed;
            this.seedDropBonus = seedBonus;
            return this;
        }

        public Builder overridePlanting(boolean overridePlanting) {
            this.overridePlanting = overridePlanting;
            return this;
        }
    }
}

